<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:passport="http://portfolio.1september.ru/works/">

<!--

Стили для чтения Паспорта работы Фестиваля «Портфолио» в браузере

Данный файл используется только для визуализации электронного паспорта работы 
в браузерах Firefox, Opera, Safari и Chrome.

-->

<xsl:output doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
            doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"/>
<xsl:output media-type="text/xhtml"/>
<xsl:output indent="yes"/>

<xsl:template match="/">

<!-- <xsl:preserve-space elements="*"/> -->
<!-- <xsl:number value="position()" grouping-separator=" " grouping-size="3"/> -->

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/xhtml; charset=UTF-8" />
	<title><xsl:value-of select="//@title"/> – Паспорт работы фестиваля «Портфолио»</title>
	<link rel="icon" href="data:image/ico;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8AiIiIG4uLi2KNjY2MjY2NoYqKiqyGhoayioqKpqCgoH66urpI1NTUGezs7AL///8A////AP///wD///8AOiwiQXxzb7KFc2/ldWJd+FpMSfhKQ0LmWVhXy11dXcSXl5egsrKyfs/Pz1Do6OgUKR8Y/6OKhaP///8A////ADosItxsV077hGxm/3RfWv9WR0T/NCsp/xUREP4MDAz1lJSUpaysrIXIyMhY5OTkGSkfGP+jioWj////AP///wA6LCL/a1ZN/4RsZv91YFv/X09M/zMqKP8VERD/AwIC/5SUlIutra1XxsbGJN3d3QQgw///////AP///wD///8ANCgf/1FAO/96Z2P/qZKN/5qEf/9uXVn/GhUU/wUEBP8AAAAE////AP///wD///8AcVRN/////wD///8AeWZgDmdWUP+pkYv/m4R+/05BPv8wKCb/Ix4d/19QTf9QREH/Ny8tCf///wD///8A////AIdwav+tlI4MuaCacq+XkeqVf3n/X05L/01APf9BNjT/NSwq/yojIf8eGRj/LCYl/3pnY/OGcm1x////AP///wCKdnHCnoaB9Y12cf9wXVj/ZlRQ/1xMSP9QQz//RTk2/zkvLf8tJST/Ihwb/xgUE/8SDw//RDo4/pB6dOlrW1dNcF5ZUmJQTOFmU0//YlBM/2hVUf9fTkr/VEVC/0g8Of88Mi//MCgm/yUfHf8aFhX/Eg8P/xUSEfwgGxr2YVNPy////wD///8ATkA+TWVTT+NlUk79YlFN/11MSP9LPjv/PzQy/zMrKf8kHRz/GhYV9hoWFfcaFhWsGhYVPP///wD///8A////AP///wD///8ARTg2VWRSTuZiUE37U0VC/ykkIv8gHBvyIh4d6R8bGncaFhUV////AP///wD///8A////AP///wD///8A////AP///wD///8AKyYkYSgjItwmIiG/Ix8eSP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A//8AAP//AAD4AAAA8AAAADAAAAAwAAAAcAcAAGAHAAAAAwAAAAAAAAAAAADAAQAA8AcAAPw/AAD//wAA//8EcA==" type="image/ico" />
	<style type="text/css">
		body {
			background-color: white;
			padding: 25px 20px 40px 20px;
			font: 80% Arial;
		}
		
		a, a:visited {
			color: #000000;
		}
		
		a:hover {
			text-decoration: none;
            color: #ffffff;
            background-color: #660066;
		}
		
		hr {
			margin-top: 30px;
		}
		
		#right_title {
			color: #C299C2;
			font-size: 130%;
			position: absolute;
			top: 25px;
			right: 20px;
			text-align: right;
		}
		#right_title p {
			margin: 0;
			padding: 0;
		}
		
		.div_image_right {
			float: right;
			width: 302px;
			margin: 30px 0 30px 40px;
		}

		.div_image_right img {
			border: #660066 solid 1px;
			-moz-box-shadow: grey 3px 3px 15px;
			-webkit-box-shadow: grey 3px 3px 15px;
			box-shadow: grey 3px 3px 15px;
		  /*-webkit-box-reflect: below 3px
				-webkit-gradient(linear, left top, left bottom, from(transparent), color-stop(0.1, transparent), to(white));*/
		}
		
	.div_image_right p {
			background-color: white;
			text-align: center;
			font-size: 90%;
			font-style: italic;
		}
		
		h1 {
			color: #660066;
            font-size: 150%;
            font-weight: bold;
            margin: auto 400px 5px auto;
		}

		dt {
			margin-top: 10px;
            font-weight: bold;
		}
		
		#footer p {
			text-align: center;
			font-size: 90%;
		}
		
	</style>

</head>

<body>

<xsl:for-each select="portfolio/work">
<xsl:sort select="@stored" />

<h1><xsl:value-of select="@title"/></h1>

<p id="right_title">Электронный паспорт работы,<br/> представленной на фестиваль «Портфолио»</p>

<div style="clear: right"/>

<xsl:for-each select="img">
	<div class="div_image_right">
		<img>
			<xsl:attribute name="src"><xsl:value-of select="@src"/></xsl:attribute>
			<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="@title"/></xsl:attribute>
			<xsl:attribute name="alt">
				Изображение к работе. Оно не поддерживается устаревшими версиями Internet Explorer до 8-й включительно. Для просмотра паспорта используйте браузеры Firefox, Opera, Safari.
			</xsl:attribute>
		</img>
		<p><xsl:value-of select="@title"/></p>
	</div>
</xsl:for-each>

<p><b>Раздел<xsl:if test="count(subjects/subject) > 1">ы</xsl:if>:</b><xsl:text> </xsl:text><xsl:if test="count(subjects/subject) = 0">не выбран</xsl:if>
	<xsl:for-each select="subjects/subject">
	<xsl:sort select="@sb_id" />
		<a><xsl:attribute name="href">http://portfolio.1september.ru/subjects/<xsl:value-of select="@sb_id"/>/</xsl:attribute>
		<xsl:choose>
        	<xsl:when test="@sb_id =  1">Астрономия, космонавтика и авиация</xsl:when>
        	<xsl:when test="@sb_id =  2">Биология</xsl:when>
        	<xsl:when test="@sb_id =  3">География</xsl:when>
        	<xsl:when test="@sb_id =  4">История, археология</xsl:when>
        	<xsl:when test="@sb_id =  5">Искусствоведение</xsl:when>
        	<xsl:when test="@sb_id =  6">Лингвистика (русский и иностранные языки)</xsl:when>
        	<xsl:when test="@sb_id =  7">Литературоведение</xsl:when>
        	<xsl:when test="@sb_id =  8">Математика</xsl:when>
        	<xsl:when test="@sb_id =  9">Религиоведение</xsl:when>
        	<xsl:when test="@sb_id = 10">Экономика, социология и право</xsl:when>
        	<xsl:when test="@sb_id = 11">Физика</xsl:when>
        	<xsl:when test="@sb_id = 12">Химия</xsl:when>
        	<xsl:when test="@sb_id = 13">Здоровье человека</xsl:when>
        	<xsl:when test="@sb_id = 14">Физкультура и спорт</xsl:when>
        	<xsl:when test="@sb_id = 15">Экология</xsl:when>
        	<xsl:when test="@sb_id = 16">Художественное творчество</xsl:when>
        	<xsl:when test="@sb_id = 17">Техническое творчество</xsl:when>
        	<xsl:when test="@sb_id = 18">Информационные технологии</xsl:when>
        	<xsl:when test="@sb_id = 19">Литературное творчество</xsl:when>
        	<xsl:when test="@sb_id = 20">Музыкальное творчество</xsl:when>
        	<xsl:when test="@sb_id = 21">Краеведение</xsl:when>
        	<xsl:when test="@sb_id = 22">В помощь учителю</xsl:when>

        	<xsl:otherwise>?</xsl:otherwise>
		</xsl:choose>
		</a>
		<xsl:if test="position() != last()">; </xsl:if>
	</xsl:for-each>
</p>

<p><b>Учебный год:</b><xsl:text> </xsl:text><xsl:value-of select="@sz_id+2004"/> / <xsl:value-of select="@sz_id+2005"/></p>

<dl>
	<dt>Автор(ы):</dt>
	<ul>
	<xsl:for-each select="authors/person">
	<xsl:sort select="@p_id_full" />
		<xsl:choose>
        	<xsl:when test="@p_type = 'student'">
        		<li>[<a><xsl:attribute name="href">http://portfolio.1september.ru/persons/<xsl:value-of select="@p_id_full"/>/</xsl:attribute><xsl:value-of select="@p_id_full"/></a>] <xsl:value-of select="@surname"/><xsl:text> </xsl:text><xsl:value-of select="@name"/><xsl:text> </xsl:text><xsl:value-of select="@patronymic"/></li>
        	</xsl:when>
		</xsl:choose>
	</xsl:for-each>
	</ul>

	<dt>Руководитель(и):</dt>
	<ul>
	<xsl:for-each select="authors/person">
	<xsl:sort select="@p_id_full" />
		<xsl:choose>
        	<xsl:when test="@p_type = 'teacher'">
        		<li>[<a><xsl:attribute name="href">http://portfolio.1september.ru/persons/<xsl:value-of select="@p_id_full"/>/</xsl:attribute><xsl:value-of select="@p_id_full"/></a>] <xsl:value-of select="@surname"/><xsl:text> </xsl:text><xsl:value-of select="@name"/><xsl:text> </xsl:text><xsl:value-of select="@patronymic"/></li>
        	</xsl:when>
		</xsl:choose>
	</xsl:for-each>
	</ul>

	<dt>Описание работы:</dt>
	<dd><xsl:value-of select="description"/></dd>

	<dt>Технические требования:</dt>
	<dd><xsl:value-of select="specification"/></dd>

	<dt>Порядок знакомства:</dt>
	<dd><xsl:value-of select="manual"/></dd>

	<dt>Контактная информация:</dt>
	<dd>Адрес: <xsl:value-of select="public_relations/postal_code"/>, <xsl:value-of select="public_relations/address"/></dd>
	<dd>Телефон: <xsl:value-of select="public_relations/phone"/></dd>
	<dd>Эл. адрес: <a><xsl:attribute name="href">mailto:<xsl:value-of select="public_relations/email"/></xsl:attribute><xsl:value-of select="public_relations/email"/></a></dd>

	<dt>Комментарии:</dt>
	<dd><xsl:value-of select="comment"/></dd>
</dl>

<hr/>

<div id="footer">
	<p>Адрес: ул. Киевская, д.24, Москва, 121165, «Первое сентября», Оргкомитет фестиваля «Портфолио»<br/>
	Телефон для справок: (499) 249-52-53. Эл. адрес: <a href="mailto:portfolio@1september.ru">portfolio@1september.ru</a></p>
	<p>© <a href="http://1september.ru/">Издательский дом «Первое сентября»</a></p>
</div>

</xsl:for-each>

</body>

</html>
</xsl:template>

</xsl:stylesheet>